/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor.trendmonitoring
{
    using System;


    /**
     * This is a very simple class that represents an event that could be 
     * considered as part of a trend.  The class simply answers the when, 
     * what and who portions of an application access.  This information 
     * is enough to determine if an event is part of a trend of application 
     * access either by a user or for the overall system.
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since June 17, 2010
     */
    public class TrendEvent
    {
        private DateTime time;
        private String resourceAccessed;
        private String accessedByName;
        private String accessedByAddress;

        public TrendEvent(DateTime time, String resourceAccessed,
                String accessedByName, String accessedByAddress)
        {
            this.time = time;
            this.resourceAccessed = resourceAccessed;
            this.accessedByName = accessedByName;
            this.accessedByAddress = accessedByAddress;
        }

        public DateTime getTime()
        {
            return time;
        }
        public void setTime(DateTime time)
        {
            this.time = time;
        }
        public String getResourceAccessed()
        {
            return resourceAccessed;
        }
        public void setResourceAccessed(String resourceAccessed)
        {
            this.resourceAccessed = resourceAccessed;
        }
        public String getAccessedByName()
        {
            return accessedByName;
        }
        public void setAccessedByName(String accessedByName)
        {
            this.accessedByName = accessedByName;
        }
        public String getAccessedByAddress()
        {
            return accessedByAddress;
        }
        public void setAccessedByAddress(String accessedByAddress)
        {
            this.accessedByAddress = accessedByAddress;
        }
    }
}